#pragma once

#include <yplatform/net/server_session_strand.h>
#include <yplatform/net/line_filter.h>
#include "session_base.h"
#include "../settings.h"

namespace ymod_messenger {

/**
 * Server session
 * delegates session processing (as base) using callback, injected in server settings
 */
class server_session
    : public session_base<yplatform::net::server_session_strand<server_settings>, server_settings>
{
    typedef session_base<yplatform::net::server_session_strand<settings_t>, settings_t> base_t;

public:
    typedef ymod_messenger::server_settings settings_t;

    server_session(yplatform::net::io_data* io_data, const settings_t& st) : base_t(io_data, st)
    {
    }

    void core_open()
    {
        if (this->settings().deps_injection.on_server_connection)
            this->settings().deps_injection.on_server_connection(get_shared_from_this());
    }

    boost::shared_ptr<server_session> get_shared_from_this()
    {
        return boost::static_pointer_cast<server_session>(shared_from_this());
    }

    void send_client_stream(const yplatform::net::buffers::const_chunk_buffer&)
    {
    }

    yplatform::net::streamer_wrapper client_stream()
    {
        yplatform::net::streamer_wrapper wrp(
            new yplatform::net::streamer<server_session>(get_shared_from_this()));
        return wrp;
    }
};

}
