#pragma once

#include <yplatform/module.h>
#include <ymod_messenger/types.h>
#include <atomic>

namespace ymod_messenger {

struct session_stats
    : public yplatform::module_stats
    , private boost::noncopyable
{
    std::atomic<uint64_t> bytes_received = { 0 };
    std::atomic<uint64_t> bytes_sent = { 0 };
    std::atomic<uint64_t> messages_received = { 0 };
    std::atomic<uint64_t> segments_sent = { 0 };
    std::atomic<uint64_t> send_queue = { 0 };

    virtual ptree_ptr get_stat() const
    {
        ptree_ptr result = yplatform::module_stats::core_get_stat();

        result->put("bytes_received", bytes_received);
        result->put("bytes_sent", bytes_sent);
        result->put("messages_received", messages_received);
        result->put("segments_sent", segments_sent);
        result->put("send_queue", send_queue);

        return result;
    }
};

typedef std::shared_ptr<session_stats> session_stats_ptr;

}