#pragma once

#include <ymod_messenger/types.h>
#include "session/messenger_session.h"
#include <algorithm>

namespace ymod_messenger {

class sessions_selector
{
    typedef messenger_session_ptr session_ptr;

public:
    typedef std::vector<session_ptr> items_t;

    sessions_selector() : current_item_index_(0)
    {
    }

    bool has(const session_ptr& session) const
    {
        return std::find(items_.begin(), items_.end(), session) != items_.end();
    }

    /// return owned and not owned (incoming) connection

    session_ptr get_session()
    {
        for (size_t i = 0; i < items_.size(); ++i)
        {
            size_t index = (current_item_index_ + i) % items_.size();
            if (items_[index]->is_open())
            {
                current_item_index_ = (index + 1) % items_.size();
                return items_[index];
            }
        }
        current_item_index_ = 0;
        return session_ptr();
    }

protected:
    size_t current_item_index_;
    items_t items_;
};

}
