#pragma once

#include "session/stats.h"
#include <yplatform/module.h>
#include <ymod_messenger/types.h>
#include <atomic>

namespace ymod_messenger {

struct stats
    : public yplatform::module_stats
    , private boost::noncopyable
{
    typedef yplatform::module_stats base_type;

    void add_session_stats(const std::string& name, session_stats_ptr stats, pool_type_t type)
    {
        base_type::lock_t lock(mux());
        stats_map.insert({ stats, std::make_tuple(name, type) });
    }

    void del_session_stats(session_stats_ptr stats)
    {
        base_type::lock_t lock(mux());
        stats_map.erase(stats);
    }

protected:
    std::map<session_stats_ptr, std::tuple<std::string, pool_type_t>> stats_map;

    virtual ptree_ptr core_get_stat() const
    {
        ptree_ptr result = base_type::core_get_stat();
        std::size_t num_incoming = 0;
        std::size_t num_outgoing = 0;
        for (auto& item : stats_map)
        {
            auto type = std::get<1>(item.second);
            auto& subptree = result->add_child(
                type == pool_INCOMING ? "incoming.connection_" + std::to_string(num_incoming++) :
                                        "outgoing.connection_" + std::to_string(num_outgoing++),
                *item.first->get_stat());
            auto& address = std::get<0>(item.second);
            subptree.put("remote", address);
        }
        return result;
    }
};

typedef boost::shared_ptr<stats> stats_ptr;

}