#pragma once

#include <boost/shared_ptr.hpp>
#include <boost/bind.hpp>

namespace {

template <typename T>
boost::shared_ptr<T> sptr_from(boost::weak_ptr<T> const& wpt)
{
    return boost::shared_ptr<T>(wpt); // throws on wpt.expired()
}
}

#define WRAP_WEAK_PTR (type, wptr) boost::bind(&sptr_from<type>, wptr);

namespace boost {
template <class T>
inline T* get_pointer(boost::weak_ptr<T> const& p)
{
    return sptr_from(p).get();
}
}