#pragma once

#include "settings.h"
#include "extract_metrics.h"
#include <ymod_webserver/server.h>
#include <yplatform/module.h>
#include <yplatform/repository.h>

namespace ymod_metricserver {

using yplatform::ptree;

class impl : public yplatform::module
{
public:
    impl(yplatform::reactor& reactor, const ptree& conf)
        : io_(*reactor.io()), settings_(conf), webserver_(io_, settings_.webserver)
    {
        bind_collect_metrics_handler();
    }

    void start()
    {
        webserver_.start();
    }

    void stop()
    {
        webserver_.stop();
    }

private:
    std::string collect_metrics()
    {
        auto stats = collect_stat_from_all_modules();
        return extract_metrics(stats);
    }

    ptree collect_stat_from_all_modules()
    {
        using lock_t = boost::unique_lock<boost::mutex>;

        ptree stat;
        lock_t lock(yplatform::repository::instance().mux());
        for (auto&& service : yplatform::repository::instance().get_services())
        {
            ptree module_stats;
            auto module = service.second.get_module_safe();
            if (auto&& stats = module->get_module_stats())
            {
                module_stats = *stats->get_stat();
            }
            else
            {
                module_stats = module->get_stats();
            }
            stat.push_back({ service.first, std::move(module_stats) });
        }
        return stat;
    }

    void bind_collect_metrics_handler()
    {
        webserver_.bind("", { "/metrics" }, [this](ymod_webserver::http::stream_ptr stream) {
            stream->set_code(ymod_webserver::codes::ok);
            stream->result_body(collect_metrics());
        });
    }

    boost::asio::io_service& io_;
    settings settings_;
    ymod_webserver::server webserver_;
};

}
