#pragma once

#include <yplatform/ptree.h>
#include <ymod_webserver/settings.h>

namespace ymod_metricserver {

struct settings
{
    unsigned short listen_port = 8092;
    ymod_webserver::settings webserver;

    settings(const yplatform::ptree& cfg)
    {
        listen_port = cfg.get("port", listen_port);
        if (auto webserver_cfg = cfg.get_child_optional("webserver"))
        {
            webserver.parse_ptree(*webserver_cfg);
        }
        webserver.endpoints.emplace("", ymod_webserver::endpoint("", "::", listen_port));
    }
};

}
