#pragma once

#include <ymod_paxos/caller.h>
#include <ymod_paxos/operation.h>
#include <ymod_paxos/types.h>
#include <boost/optional.hpp>
#include <memory>
#include <string>

namespace ymod_paxos {

class sync_manager : public iabstract
{
public:
    using serialized_data_type = std::string;

    virtual boost::optional<serialized_data_type> make_delta_request() = 0;
    virtual void apply_delta(const serialized_data_type& message) = 0;
    virtual size_t remained() const = 0;
    virtual bool finished() const = 0;
};

class abstract_database : public iabstract
{
public:
    using sync_manager_ptr = std::shared_ptr<sync_manager>;
    using serialized_data_type = std::string;

    // db is in correct state
    virtual bool is_ok() = 0;
    // current data revision
    virtual iid_t get_revision() = 0;
    // exec operations
    virtual bool is_modifying(const operation& op) = 0;
    virtual void apply(iid_t iid, operation op, std::weak_ptr<icaller> caller) = 0;
    // sync client
    virtual sync_manager_ptr start_sync(const serialized_data_type& snapshot) = 0;
    virtual void finish_sync(sync_manager_ptr sync_manager) = 0;
    // sync server
    virtual serialized_data_type get_snapshot() = 0;
    virtual serialized_data_type get_delta(const serialized_data_type& request) = 0;
};

}
