#pragma once

#include <stdexcept>
#include <string>
#include <vector>

namespace ymod_paxos {

//@todo add error for too large events, http code 413
enum ErrorCode
{
    ErrorCode_UNKNOWN_ERROR = 1,
    ErrorCode_DOWN,
    ErrorCode_NOT_UPTODATE,
    ErrorCode_LAGGING,
    ErrorCode_CANT_PREPROCESS,
    ErrorCode_CANT_BROADCAST,
    ErrorCode_CANT_ENQUEUE,
    ErrorCode_CANT_EXECUTE,
    ErrorCode_BAD_REQUEST,
    ErrorCode_BAD_REQUEST_ARGUMENTS,
    ErrorCode_PREPROCESS_TIMEOUT,
    ErrorCode_CANCELED,
    ErrorCode_DUPLICATE,
    ErrorCode_CONSENSUS_TIMEOUT,
    ErrorCode_NOT_MASTER,
    ErrorCode_DB_IS_CORRUPTED,
};

template <typename CODE_TYPE, CODE_TYPE def>
class basic_error : public std::domain_error
{
public:
    basic_error(const std::exception& e) : std::domain_error(e.what()), code_(def)
    {
    }

    explicit basic_error(const CODE_TYPE code, const std::string& message)
        : std::domain_error(message), code_(code)
    {
    }

    CODE_TYPE code() const throw()
    {
        return code_;
    }

private:
    CODE_TYPE code_;
};

typedef basic_error<ErrorCode, ErrorCode_UNKNOWN_ERROR> error;

}
