#pragma once

#include <tuple>

namespace ymod_paxos { namespace detail {

template <typename TypeList, typename T, int index, bool>
struct find_index;

template <typename TypeList, typename T, int index>
struct find_index<TypeList, T, index, false>
{
    static const int value = find_index<
        TypeList,
        T,
        index - 1,
        std::is_same<typename std::tuple_element<index - 1, TypeList>::type, T>::value>::value;
};

template <typename TypeList, typename T, int index>
struct find_index<TypeList, T, index, true>
{
    static const int value = index;
};

template <typename TypeList, typename T>
struct not_found;

template <typename TypeList, typename T>
struct find_index<TypeList, T, 0, false>
{
    static const int value = not_found<TypeList, T>::value;
};

} // namespace detail
} // namespace ymod_paxos
