#pragma once

///@todo split this file
#include <ymod_paxos/network/netch.h>
#include <ymod_paxos/operation.h>
#include <multipaxos/messages.h>
#include <ymod_paxos/types.h>
#include <msgpack.hpp>
#include <vector>

namespace ymod_paxos {

using multipaxos::prepare_message;
using multipaxos::accept_message;
using multipaxos::sync_request_message;
using multipaxos::master_announce_message;
using multipaxos::promise_message;
using multipaxos::learn_message;
using multipaxos::reject_message;
using multipaxos::sync_response_message;

#define DEFAULT_PAXOS_NETWORK_BASE 5000
#define DEFAULT_RLOG_NETWORK_BASE 25000

#define USR_BASE base + ymod_messenger::message_type_USER

struct sync_message_types
{
    sync_message_types(netch_message_code base)
        : lookup(USR_BASE + 1)
        , lookup_answer(USR_BASE + 2)
        , catch_up(USR_BASE + 3)
        , catch_up_answer(USR_BASE + 4)
        , catch_up_error(USR_BASE + 5)
        , catch_up_get_delta(USR_BASE + 6)
        , catch_up_get_delta_answer(USR_BASE + 7)
        , catch_up_get_delta_error(USR_BASE + 8)
    {
    }

    const netch_message_code lookup;
    const netch_message_code lookup_answer;
    const netch_message_code catch_up;
    const netch_message_code catch_up_answer;
    const netch_message_code catch_up_error;
    const netch_message_code catch_up_get_delta;
    const netch_message_code catch_up_get_delta_answer;
    const netch_message_code catch_up_get_delta_error;
};

struct redirect_message
{
    std::string op_uniq_id;
    multipaxos::value_t op;
    MSGPACK_DEFINE(op_uniq_id, op);
};

struct redirect_response_message
{
    std::string op_uniq_id;
    std::string data;
    std::map<std::string, std::string> attributes;
    MSGPACK_DEFINE(op_uniq_id, data, attributes);
};

struct lookup_message
{
    string session_id;
    MSGPACK_DEFINE(session_id);
};

struct lookup_answer_message
{
    lookup_answer_message() : value(0), master(false), invalid(false), up(false)
    {
    }
    string session_id;
    iid_t value;
    bool master;
    bool invalid;
    bool up;
    MSGPACK_DEFINE(session_id, value, master, invalid, up);
};

struct catch_up_message
{
    string session_id;
    MSGPACK_DEFINE(session_id);
};

#undef USR_BASE

}
