#pragma once

#include <ymod_paxos/caller.h>
#include <ymod_paxos/operation.h>
#include <ymod_paxos/types.h>
#include <yplatform/task_context.h>
#include <set>
#include <string>

namespace ymod_paxos {

class node : public iabstract
{
public:
    struct status;

    virtual void perform(
        const task_context_ptr& ctx,
        operation op,
        std::shared_ptr<icaller> caller) = 0;
    virtual bool is_master() = 0;
    virtual void reset_replica() = 0;
    virtual status get_status() = 0;
    virtual void set_id(unsigned id) = 0;
};

struct node::status
{
    std::string status;
    iid_t revision = -1;
    bool is_master = 0;
    bool master_available = 0;
    std::time_t up_time = 0;
};

}
