#include "acceptor_module.h"

#include <ymod_paxos/network.h>
#include <ymod_paxos/packing.hpp>
#include <multipaxos/types.h>
#include <multipaxos/timers_queue.h>
#include <multipaxos/ts_acceptor.h>
#include <multipaxos/acceptor_storage_bdb.h>
#include <multipaxos/acceptor_storage_memory.h>
#include <boost/filesystem/operations.hpp>
#include <msgpack.hpp>
#include <sstream>

#define DL verbose_logging_
#define DEFAULT_MAX_JOURNAL_SIZE 300000

namespace ymod_paxos {

using namespace multipaxos;

void acceptor_module::init(const yplatform::ptree& xml)
{
    auto mod_netch = yplatform::find<netch, std::shared_ptr>(xml.get("netch", "netch"));
    auto paxos_message_base =
        xml.get<netch_message_code>("paxos_message_code_base", DEFAULT_PAXOS_NETWORK_BASE);
    auto network = std::make_shared<paxos_network>(mod_netch, paxos_message_base);

    bool useDiskStorage = (xml.get("use-disk-storage", "0") == "1");
    unsigned max_journal_size = xml.get<unsigned>("max_journal_size", DEFAULT_MAX_JOURNAL_SIZE);

    std::shared_ptr<acceptor_storage_interface> storage;
    if (useDiskStorage)
    {
        string workingDirectory = xml.get("path", "/var/acceptor");
        if (!boost::filesystem::exists(workingDirectory))
        {
            boost::filesystem::create_directories(workingDirectory);
        }
        string fileName = workingDirectory + "/stable.db";
        storage = std::make_shared<acceptor_storage_bdb>(fileName, max_journal_size, false);
    }
    else
    {
        storage = std::make_shared<acceptor_storage_memory>(max_journal_size);
    }

    auto paxos_log_id = xml.get<std::string>("paxos_log_id");
    auto custom_logger = yplatform::log::source(YGLOBAL_LOG_SERVICE, paxos_log_id);
    auto global_reactor = yplatform::global_net_reactor;
    acceptor_ =
        std::make_shared<impl_type>(network, ylogger(custom_logger, ylogger::level::info), storage);
}

void acceptor_module::init(std::shared_ptr<netch> netch)
{
    auto network = std::make_shared<paxos_network>(netch, DEFAULT_PAXOS_NETWORK_BASE);
    acceptor_ = std::make_shared<impl_type>(
        network, ylogger(), std::make_shared<acceptor_storage_memory>(DEFAULT_MAX_JOURNAL_SIZE));
}

void acceptor_module::fini()
{
    acceptor_.reset();
}

}
