#pragma once

#include <ymod_paxos/db.h>
#include <ymod_paxos/network.h>
#include <ymod_paxos/node.h>
#include <ymod_lease/node.h>
#include <sintimers/queue.h>
#include <yplatform/module.h>
#include <atomic>

namespace ymod_paxos {

class rlog_t;
class lookup_client;
class lookup_server;
class catch_up_client;
class catch_up_server;

class node_impl
    : public yplatform::module
    , public ymod_paxos::node
{
public:
    void init_network(const yplatform::ptree& xml);
    void init(const yplatform::ptree& xml);
    void start();
    void stop();
    void perform(const task_context_ptr& ctx, operation op, std::shared_ptr<icaller> caller)
        override;
    bool is_master() override;
    void reset_replica() override;
    yplatform::ptree get_stats() const override;
    node::status get_status() override;
    void set_id(unsigned id) override;

protected:
    void start_lookup();
    void start_catch_up();
    void open_replica();
    void close_replica();
    void start_master_election();
    void stop_master_election();
    bool data_is_ok();
    void handle_win_lease(
        const string& resourceName,
        const ymod_lease::node_id& node,
        const ymod_lease::ballot_t ballot);
    void handle_lose_lease(const string& resourceName);
    void start_service_timer();
    void handle_service_timer();
    void set_master();
    void set_not_master();

    std::shared_ptr<rlog_t> rlog_;
    std::shared_ptr<ymod_paxos::lookup_client> lookup_client_;
    std::shared_ptr<ymod_paxos::lookup_server> lookup_server_;
    std::shared_ptr<ymod_paxos::catch_up_client> catch_up_client_;
    std::shared_ptr<ymod_paxos::catch_up_server> catch_up_server_;

    std::shared_ptr<timers::queue> timers_;

    std::shared_ptr<abstract_database> database_;

    unsigned cluster_size_;

    std::shared_ptr<netch> netch_;
    std::shared_ptr<netch> sync_netch_;
    std::shared_ptr<netch> lease_netch_;
    std::shared_ptr<ymod_lease::node> lease_node_;

    struct
    {
        std::atomic<uint64_t> group_splits = { 0 };
        std::atomic<uint64_t> performed = { 0 };
        std::atomic<uint64_t> canceled_no_master = { 0 };
    } stats_;

    bool stop_ = true;
    unsigned id_ = 0;     // paxos proposer id, used as an optimization and might be 0
    string cluster_name_; // is used as lease resource name
    std::atomic<bool> is_master_ = { false };
    std::atomic<bool> master_available_ = { false };
    std::time_t start_time_ = 0;
    std::time_t up_time_ = 0;
    std::atomic<const std::string*> db_status_;
    std::shared_ptr<boost::asio::io_service::strand> strand_;

    timers::timer_ptr service_timer_;
    time_duration service_timer_interval_;
};

}
