#pragma once

#include <ymod_paxos/types.h>
#include <boost/circular_buffer.hpp>
#include <unordered_set>

namespace ymod_paxos {

template <typename T>
class lru_cache
{
public:
    typedef T value_type;

    lru_cache(size_t size) : queue_(size)
    {
    }

    void push(value_type v)
    {
        lock_t lock(mutex_);
        if (queue_.full())
        {
            set_.erase(queue_.front());
        }
        queue_.push_back(v);
        set_.insert(v);
    }

    bool has(value_type v)
    {
        lock_t lock(mutex_);
        return set_.count(v) > 0;
    }

    void clear()
    {
        queue_.clear();
        set_.clear();
    }

private:
    mutex_t mutex_;
    boost::circular_buffer<value_type> queue_;
    std::unordered_set<value_type> set_;
};

}
