#include "redirect_caller.h"

#include <ymod_paxos/network/messages.h>

namespace ymod_paxos {

redirect_caller::redirect_caller(
    std::shared_ptr<paxos_network> network,
    const netch_address& callback_address)
    : network_(network), address_(callback_address), dirty_call_(false)
{
}

void redirect_caller::set_attribute(const string& name, const string& value)
{
    if (dirty_call_) result_.attributes[name] = value;
}

void redirect_caller::set_result(const std::string& uniq_id, const string& data)
{
    // send results only for dirty executed operations
    if (!dirty_call_) return;
    result_.op_uniq_id = uniq_id;
    result_.data = data;
    network_->send(result_, address_);
    YLOG_L(debug) << "sending result for redirected operation " << uniq_id;
}

void redirect_caller::set_error(const std::string& /*uniq_id*/, const ymod_paxos::error& /*e*/)
{
    /*ignore*/
}

void redirect_caller::set_dirty_call()
{
    dirty_call_ = true;
}

}
