#pragma once

#include <ymod_paxos/caller.h>
#include <ymod_paxos/operation.h>
#include <ymod_paxos/network.h>
#include <ymod_paxos/packing.hpp>
#include <string>

namespace ymod_paxos {

class redirect_caller : public ymod_paxos::icaller
{
public:
    redirect_caller(std::shared_ptr<paxos_network> network, const netch_address& callback_address);
    void set_attribute(const string& name, const string& value);
    void set_result(const std::string& uniq_id, const string& data);
    void set_error(const std::string& uniq_id, const ymod_paxos::error& e);
    void set_dirty_call();

private:
    redirect_response_message result_;
    std::shared_ptr<paxos_network> network_;
    netch_address address_;
    bool dirty_call_;
};

}
