#pragma once

#include <ymod_paxos/network/messages.h>
#include <ymod_paxos/network.h>
#include <ymod_paxos/types.h>
#include <multipaxos/settings.h>
#include <yplatform/ptree.h>

namespace ymod_paxos {

struct rlog_settings
{
    time_duration default_redirect_timeout = seconds(4);
    unsigned total_log_size = 5000;
    bool agent_log_enabled = true;
    bool agent_debug_log_enabled = false;
    std::string paxos_log_id;
    multipaxos::algorithm_settings_t algorithm;

    void load(const yplatform::ptree& conf)
    {
        default_redirect_timeout =
            milliseconds(conf.get<long>("default_redirect_to_master_timeout_ms"));
        total_log_size = conf.get<unsigned>("total_journal_size");
        agent_debug_log_enabled = conf.get<bool>("paxos_debug_log", agent_debug_log_enabled);
        paxos_log_id = conf.get<std::string>("paxos_log_id");
        agent_log_enabled = (paxos_log_id != "");

        auto algorith_conf = conf.get_child_optional("algorithm");
        if (algorith_conf) algorithm = get_algorithm_settings(*algorith_conf);
    }

    static multipaxos::algorithm_settings_t get_algorithm_settings(const yplatform::ptree& conf)
    {
        multipaxos::algorithm_settings_t algorith_settings;
        algorith_settings.drop_submits_while_preparing =
            conf.get<bool>("drop_submits_while_preparing");
        algorith_settings.prepare_max_time = milliseconds(conf.get<unsigned>("p1_timeout_ms"));
        algorith_settings.propose_max_time = milliseconds(conf.get<unsigned>("p2_timeout_ms"));
        algorith_settings.max_prepare_step = conf.get<unsigned>("max_prepare_step");
        algorith_settings.max_parallel_accepts = conf.get<unsigned>("max_parallel_accepts");
        algorith_settings.announce_interval =
            milliseconds(conf.get<unsigned>("announce_interval_ms"));
        algorith_settings.lag_to_report = conf.get<unsigned>("sync_lag_to_report");
        algorith_settings.sync_interval = milliseconds(conf.get<unsigned>("sync_interval_ms"));
        algorith_settings.sync_max_size = conf.get<unsigned>("sync_max_size");
        return algorith_settings;
    }
};

} // namespace ymod_paxos
