#pragma once

#include <ymod_paxos/types.h>
#include <multipaxos/stats.h>
#include <yplatform/module.h>
#include <string>
#include <set>

namespace ymod_paxos {

struct rlog_stats : private boost::noncopyable
{
    multipaxos::stats_t multipaxos_stats;
    std::atomic<uint64_t> executed = { 0 };
    std::atomic<uint64_t> canceled = { 0 };
    std::atomic<uint64_t> redirects_sent = { 0 };
    std::atomic<uint64_t> redirects_received = { 0 };

    void to_ptree(yplatform::ptree& result)
    {
        result.put("submits", multipaxos_stats.submits);
        result.put("learns_received", multipaxos_stats.learns_received);
        result.put("learns_skipped_wrong_ballot", multipaxos_stats.learns_skipped_wrong_ballot);
        result.put("reset_prepare", multipaxos_stats.reset_prepare);
        result.put("executed", executed);
        result.put("canceled", canceled);
        result.put("redirects_sent", redirects_sent);
        result.put("redirects_received", redirects_received);
    }
};

}
