#pragma once

#include <ymod_paxos/error.h>
#include <ymod_paxos/db.h>
#include <ymod_paxos/network.h>
#include <ymod_paxos/packing.hpp>
#include <ymod_paxos/types.h>
#include <ymod_messenger/types.h>
#include <sintimers/queue.h>
#include <yplatform/util/uuid_generator.h>
#include <boost/function.hpp>

namespace ymod_paxos {

typedef boost::function<void(void)> CatchUpCallback;
typedef boost::function<void(void)> ErrorCallback;

struct catch_up_session
{
    std::shared_ptr<abstract_database> db;
    string id;
    CatchUpCallback success_cb;
    ErrorCallback error_cb;

    netch_address source;
    abstract_database::sync_manager_ptr sync_manager;

    bool snapshot_received()
    {
        return source != "";
    }

    bool finished()
    {
        return sync_manager && sync_manager->finished();
    }
};

class catch_up_client : public yplatform::log::contains_logger
{
public:
    catch_up_client(
        std::shared_ptr<netch> netch,
        const sync_message_types& message_types,
        std::shared_ptr<timers::queue> timers,
        const time_duration& timeout = seconds(4),
        unsigned concurrency = 2);

    void stop();
    void catch_up(
        std::shared_ptr<abstract_database> db,
        const CatchUpCallback& cb,
        const ErrorCallback& error_cb);
    size_t remained();

    void handle_get_snapshot_answer(
        const netch_address&,
        const abstract_database::serialized_data_type&);
    void handle_get_delta_answer(
        const netch_address&,
        const abstract_database::serialized_data_type&);

private:
    void check_catch_up_deadline();
    void request_records(const netch_address& addr, lock_t& lock);
    void finish_catch_up(lock_t& lock);

    mutex_t mutex_;
    bool stop_;
    std::shared_ptr<netch> netch_;
    sync_message_types sync_messages_;
    std::shared_ptr<timers::queue> timers_;
    timers::timer_ptr deadline_;
    time_duration timeout_;
    unsigned concurrency_;
    yplatform::util::string_uuid_generator uuid_generator_;
    std::unique_ptr<catch_up_session> session_;
};

}
