#include "sync/catch_up_server.h"
#include <ymod_paxos/packing.hpp>

namespace ymod_paxos {

catch_up_server::catch_up_server(
    std::shared_ptr<netch> netch,
    const sync_message_types& sync_message_types)
    : netch_(netch), sync_messages_(sync_message_types)
{
    netch_->bind_messages<catch_up_message>(
        boost::bind(&catch_up_server::handle_get_snapshot, this, _1, _2), sync_messages_.catch_up);
    netch_->bind_messages<abstract_database::serialized_data_type>(
        boost::bind(&catch_up_server::handle_get_delta, this, _1, _2),
        sync_messages_.catch_up_get_delta);
}

void catch_up_server::start(std::shared_ptr<abstract_database> db)
{
    lock_t lock(mutex_);
    db_ = db;
}

void catch_up_server::stop()
{
    lock_t lock(mutex_);
    db_.reset();
}

void catch_up_server::handle_get_snapshot(
    const netch_address& addr,
    const catch_up_message& /*message*/)
{
    lock_t lock(mutex_);
    if (!db_) return;
    if (!master_) return;
    netch_->send(addr, db_->get_snapshot(), sync_messages_.catch_up_answer);
}

void catch_up_server::handle_get_delta(
    const netch_address& addr,
    const abstract_database::serialized_data_type& data)
{
    lock_t lock(mutex_);
    if (!db_) return;
    netch_->send(addr, db_->get_delta(data), sync_messages_.catch_up_get_delta_answer);
}

}
