#pragma once

#include <ymod_paxos/types.h>
#include <ymod_paxos/db.h>
#include <ymod_paxos/network.h>
#include <ymod_paxos/error.h>
#include <ymod_messenger/types.h>

#include <boost/function.hpp>

namespace ymod_paxos {

class catch_up_server : public yplatform::log::contains_logger
{
public:
    catch_up_server(std::shared_ptr<netch> netch, const sync_message_types& message_types);

    void start(std::shared_ptr<abstract_database> db);
    void stop();
    void handle_get_snapshot(const netch_address&, const catch_up_message&);
    void handle_get_delta(const netch_address&, const abstract_database::serialized_data_type&);

    void set_master(bool master = true)
    {
        lock_t lock(mutex_);
        master_ = master;
    }

private:
    mutex_t mutex_;
    std::shared_ptr<abstract_database> db_;
    bool master_ = false;
    std::shared_ptr<netch> netch_;
    sync_message_types sync_messages_;
};

}
