#pragma once

#include <ymod_paxos/types.h>
#include <ymod_paxos/network.h>
#include <ymod_paxos/packing.hpp>
#include <ymod_paxos/error.h>
#include <ymod_paxos/db.h>
#include <ymod_messenger/types.h>
#include <yplatform/util/uuid_generator.h>
#include <sintimers/queue.h>
#include <boost/function.hpp>

namespace ymod_paxos {

typedef boost::function<void(bool)> LookupCallback;
typedef boost::function<void(void)> ErrorCallback;

struct lookup_session
{

    lookup_session() : retry_number(0), cluster_size(0), answers(0), prev_answers(0)
    {
    }
    string id;
    unsigned retry_number;
    size_t cluster_size;
    LookupCallback success_cb;
    ErrorCallback error_cb;
    std::map<netch_address, iid_t> values;
    unsigned answers;
    unsigned prev_answers;
    iid_t revision;
};

class lookup_client : public yplatform::log::contains_logger
{
public:
    lookup_client(
        std::shared_ptr<netch> netch,
        const sync_message_types& message_types,
        std::shared_ptr<timers::queue> timers,
        const time_duration& timeout = seconds(4),
        unsigned retry_count = 2);

    void lookup(
        size_t cluster_size,
        iid_t revision,
        const LookupCallback& cb,
        const ErrorCallback& error_cb);
    void stop();

private:
    void lookup_try(lock_t& lock);
    void check_lookup_deadline();
    void check_lookup_results(lock_t& lock);
    void on_message_lookup_answer(const netch_address&, const lookup_answer_message&);

    mutex_t mutex_;
    yplatform::util::string_uuid_generator uuid_generator_;
    bool stop_;
    std::unique_ptr<lookup_session> lookup_session_;
    std::shared_ptr<netch> netch_;
    sync_message_types sync_messages_;
    std::shared_ptr<timers::queue> timers_;
    timers::timer_ptr lookup_timer_;
    time_duration timeout_;
    unsigned retry_count_;
};

}
