#include "sync/lookup_server.h"
#include <ymod_paxos/packing.hpp>

namespace ymod_paxos {

lookup_server::lookup_server(
    std::shared_ptr<netch> netch,
    const sync_message_types& sync_message_types)
    : netch_(netch), sync_messages_(sync_message_types)
{
    netch_->bind_messages<lookup_message>(
        boost::bind(&lookup_server::on_message_lookup, this, _1, _2), sync_messages_.lookup);
}

void lookup_server::on_message_lookup(const netch_address& addr, const lookup_message& message)
{
    YLOG_L(debug) << "lookup message received from " << addr;

    lookup_answer_message answer;
    answer.session_id = message.session_id;

    lock_t lock(mutex_);
    if (database_)
    {
        answer.value = database_->get_revision();
        answer.invalid = false;
        answer.master = master_;
        answer.up = true;
    }
    else
    {
        answer.value = rev_;
        answer.invalid = false;
        answer.master = false;
        answer.up = false;
    }
    YLOG_G(info) << "lookup_server answer: rev=" << answer.value;
    lock.unlock();

    netch_->send(addr, answer, sync_messages_.lookup_answer);
}

}
