#pragma once

#include <ymod_paxos/types.h>
#include <ymod_paxos/db.h>
#include <ymod_paxos/network.h>
#include <ymod_paxos/network/messages.h>
#include <ymod_paxos/error.h>
#include <ymod_messenger/types.h>
#include <boost/function.hpp>

namespace ymod_paxos {

class lookup_server : public yplatform::log::contains_logger
{
public:
    lookup_server(std::shared_ptr<netch> netch, const sync_message_types& message_types);

    void stop()
    {
    }

    void reset_source(iid_t rev)
    {
        lock_t lock(mutex_);
        rev_ = rev;
        master_ = false;
        database_.reset();
    }

    void set_source(std::shared_ptr<abstract_database> database)
    {
        lock_t lock(mutex_);
        rev_ = -1;
        database_ = database;
    }

    void set_master(bool master = true)
    {
        lock_t lock(mutex_);
        master_ = master;
    }

    void on_message_lookup(const netch_address&, const lookup_message&);

private:
    mutex_t mutex_;
    std::shared_ptr<netch> netch_;
    sync_message_types sync_messages_;
    iid_t rev_ = -1;
    bool master_ = false;
    std::shared_ptr<abstract_database> database_;
};

}
