#pragma once

#include <yplatform/log.h>
#include <boost/asio/io_service.hpp>
#include <boost/asio/strand.hpp>
#include <string>

namespace ymod_paxos {

class ylogger
{
public:
    enum class level
    {
        debug,
        info,
        warn,
        error,
        off,
    };

    ylogger(const yplatform::log::source& logger, level level) : impl(logger), current_level(level)
    {
    }
    ylogger() : current_level(level::off)
    {
    }
    level log_level() const
    {
        return current_level;
    }
    void error(const std::string& line)
    {
        if (current_level <= level::error) YLOG(impl, error) << line;
    }
    void warn(const std::string& line)
    {
        if (current_level <= level::warn) YLOG(impl, warning) << line;
    }
    void info(const std::string& line)
    {
        if (current_level <= level::info) YLOG(impl, info) << line;
    }
    void debug(const std::string& line)
    {
        if (current_level <= level::debug) YLOG(impl, debug) << line;
    }

private:
    yplatform::log::source impl;
    std::shared_ptr<boost::asio::io_service::strand> strand;
    level current_level;
};

} // namespace ymod_paxos
