#ifndef _YMOD_POP_CLIENT_CALL_H_
#define _YMOD_POP_CLIENT_CALL_H_

#include <ymod_popclient/config.h>
#include <yplatform/module.h>
#include <yplatform/task_context.h>
#include <yplatform/future/future.hpp>
#include <boost/property_tree/ptree.hpp>
#include <boost/shared_ptr.hpp>

namespace ymod_pop_client {

struct message_info
{
    message_info() : id(-1), size(0)
    {
    }

    message_info(int id_, std::size_t size_, const string& uidl_ = "")
        : id(id_), size(size_), uidl(uidl_)
    {
    }

    int id;
    std::size_t size;
    string uidl;
};

struct mailbox_stat
{
    mailbox_stat() : count(-1), all_size(0)
    {
    }

    mailbox_stat(int c, std::size_t s) : count(c), all_size(s)
    {
    }

    int count;
    std::size_t all_size;
};

struct connect_result
{
    std::string server_ip;
    std::string welcome_message;
};

typedef std::map<int, message_info> message_list_t;

typedef boost::shared_ptr<string> string_ptr;
typedef boost::shared_ptr<message_list_t> message_list_ptr;
typedef boost::shared_ptr<mailbox_stat> mailbox_stat_ptr;

typedef yplatform::future::future<string_ptr> future_string_ptr;
typedef yplatform::future::future<connect_result> future_connect_result;
typedef yplatform::future::future<message_list_ptr> future_msg_list_ptr;
typedef yplatform::future::future<mailbox_stat_ptr> future_mb_stat_ptr;
typedef yplatform::future::future<bool> future_bool_t;

typedef yplatform::future::promise<string_ptr> promise_string_ptr;
typedef yplatform::future::promise<connect_result> promise_connect_result;
typedef yplatform::future::promise<message_list_ptr> promise_msg_list_ptr;
typedef yplatform::future::promise<mailbox_stat_ptr> promise_mb_stat_ptr;
typedef yplatform::future::promise<bool> promise_bool_t;

class call : public yplatform::module
{
public:
    virtual future_string_ptr resolve(
        yplatform::task_context_ptr context,
        const string& server) = 0;
    // if success return server IP
    virtual future_connect_result connect(
        yplatform::task_context_ptr context,
        const string& server,
        unsigned short port,
        bool ssl) = 0;

    virtual future_bool_t login(
        yplatform::task_context_ptr context,
        const string& user,
        const string& password) = 0;

    virtual future_bool_t quit(yplatform::task_context_ptr context) = 0;

    virtual future_mb_stat_ptr load_stat(yplatform::task_context_ptr context) = 0;

    virtual future_string_ptr load_uidl(yplatform::task_context_ptr context, int id) = 0;

    virtual future_msg_list_ptr load_msg_list(
        yplatform::task_context_ptr context,
        bool uidls = true,
        bool size = true) = 0;

    virtual future_string_ptr load_msg(
        yplatform::task_context_ptr context,
        int id,
        int lines = -1,
        bool erase_dots = true) = 0;

    virtual future_bool_t delete_msg(yplatform::task_context_ptr context, int id) = 0;

    virtual future_bool_t reset_changes(yplatform::task_context_ptr context) = 0;
};

}

#endif // _YMOD_POP_CLIENT_CALL_H_
