#include <yplatform/module.h>
#include "call_impl.h"
#include "context.h"

namespace ymod_pop_client {

call_impl::call_impl() : yplatform::net::client_module<session>("pop3_client")
{
    L_(debug) << "pop_client task instaniated";
}

call_impl::~call_impl()
{
    L_(debug) << "pop_client task destroyed";
    client_->stop();
}

void call_impl::init(const yplatform::ptree& xml)
{
    if (!yplatform::net::client_module<session>::open_client(xml))
    {
        L_(fatal) << "invalid pop3 client options";
        throw std::runtime_error("invalid pop3 client options");
    }
}

void call_impl::fini()
{
    client_->stop();
}

void call_impl::start(void)
{
    run_client();
}

future_string_ptr call_impl::resolve(yplatform::task_context_ptr context, const string& server)
{
    session_ptr sess = get_session(context);
    return sess->resolve(server);
}

future_connect_result call_impl::connect(
    yplatform::task_context_ptr context,
    const string& server,
    unsigned short port,
    bool ssl)
{
    context->erase_module_data("pop_client");
    session_ptr sess = get_session(context);
    return sess->connect(server, port, ssl);
}

future_bool_t call_impl::login(
    yplatform::task_context_ptr context,
    const string& user,
    const string& password)
{
    session_ptr sess = get_session(context);
    return sess->login(user, password);
}

future_bool_t call_impl::quit(yplatform::task_context_ptr context)
{
    session_ptr sess = get_session(context);
    return sess->quit();
}

future_mb_stat_ptr call_impl::load_stat(yplatform::task_context_ptr context)
{
    session_ptr sess = get_session(context);
    return sess->load_stat();
}

future_string_ptr call_impl::load_uidl(yplatform::task_context_ptr context, int id)
{
    session_ptr sess = get_session(context);
    return sess->load_uidl(id);
}

future_msg_list_ptr call_impl::load_msg_list(
    yplatform::task_context_ptr context,
    bool uidls,
    bool size)
{
    session_ptr sess = get_session(context);
    return sess->load_msg_list(size, uidls);
}

future_string_ptr call_impl::load_msg(
    yplatform::task_context_ptr context,
    int id,
    int lines,
    bool erase_dots)
{
    session_ptr sess = get_session(context);
    return sess->load_msg(id, lines, erase_dots);
}

future_bool_t call_impl::delete_msg(yplatform::task_context_ptr context, int id)
{
    session_ptr sess = get_session(context);
    return sess->delete_msg(id);
}

future_bool_t call_impl::reset_changes(yplatform::task_context_ptr context)
{
    session_ptr sess = get_session(context);
    return sess->reset_changes();
}

session_ptr call_impl::get_session(yplatform::task_context_ptr context)
{
    session_ctx_ptr stat = context->create_module_data<session_ctx>("pop_client");
    if (stat->session) return stat->session;
    session_ptr sess = this->client_->create_session(settings_);
    sess->set_context(context);
    stat->session = sess;
    return sess;
}

}

#include <yplatform/module_registration.h>
DEFINE_SERVICE_OBJECT(ymod_pop_client::call_impl)
