#ifndef _YMOD_POP_CLIENT_CALL_IMPL_H_
#define _YMOD_POP_CLIENT_CALL_IMPL_H_

#include <ymod_popclient/call.h>
#include <yplatform/net/module.h>
#include "session.h"

namespace ymod_pop_client {

class call_impl
    : public call
    , public yplatform::net::client_module<session>
{
public:
    call_impl();

    virtual ~call_impl();

    void init(const yplatform::ptree& xml);

    void fini(void);

    void start();

    virtual const yplatform::module_stats_ptr get_module_stats() const
    {
        return client_->stats();
    }

    future_string_ptr resolve(yplatform::task_context_ptr context, const string& server);

    future_connect_result connect(
        yplatform::task_context_ptr context,
        const string& server,
        unsigned short port,
        bool ssl);

    virtual future_bool_t login(
        yplatform::task_context_ptr context,
        const string& user,
        const string& password);

    virtual future_bool_t quit(yplatform::task_context_ptr context);

    virtual future_mb_stat_ptr load_stat(yplatform::task_context_ptr context);

    virtual future_string_ptr load_uidl(yplatform::task_context_ptr context, int id);

    virtual future_msg_list_ptr load_msg_list(
        yplatform::task_context_ptr context,
        bool uidls = true,
        bool size = true);

    virtual future_string_ptr load_msg(
        yplatform::task_context_ptr context,
        int id,
        int lines,
        bool erase_dots);

    virtual future_bool_t delete_msg(yplatform::task_context_ptr context, int id);

    virtual future_bool_t reset_changes(yplatform::task_context_ptr context);

private:
    session_ptr get_session(yplatform::task_context_ptr context);
};

}

#endif // _YMOD_POP_CLIENT_CALL_IMPL_H_
