#ifndef _YMOD_POP_CLIENT_FILTER_H_
#define _YMOD_POP_CLIENT_FILTER_H_

#include <utility>
#include <yplatform/net/line_filter.h>

namespace ymod_pop_client {

class filter : public yplatform::net::proto_filter
{
public:
    filter() : state_(BEFORE_RESPONSE), multi_line_(false)
    {
    }

    void set_mode(bool multi_line)
    {
        multi_line_ = multi_line;
    }

    template <typename Iterator>
    std::pair<Iterator, bool> operator()(Iterator begin, Iterator end);

private:
    enum PROTO_STATE
    {
        BEFORE_RESPONSE,
        BEFORE_ERR_RESPONSE,
        BEFORE_SUCCESS_RESPONSE,
        RESPONSE_BODY,
        BODY_AFTER_LF,
        BODY_AFTER_DOT,
        BODY_AFTER_CR
    } state_;
    bool multi_line_;
};

template <typename Iterator>
std::pair<Iterator, bool> filter::operator()(Iterator begin, Iterator end)
{
    Iterator i = begin;
    for (; i != end; ++i)
    {
        switch (state_)
        {
        case BEFORE_RESPONSE:
        {
            if (*i == '+') state_ = BEFORE_SUCCESS_RESPONSE;
            else
                state_ = BEFORE_ERR_RESPONSE;
        }
        break;
        case BEFORE_ERR_RESPONSE:
        case BEFORE_SUCCESS_RESPONSE:
        {
            if (*i != '\n') continue;
            if (state_ == BEFORE_ERR_RESPONSE || !multi_line_)
            {
                state_ = BEFORE_RESPONSE;
                return std::make_pair(i, true);
            }
            state_ = BODY_AFTER_LF;
        }
        break;
        case RESPONSE_BODY:
        {
            if (*i == '\n') state_ = BODY_AFTER_LF;
        }
        break;
        case BODY_AFTER_LF:
        {
            if (*i == '.') state_ = BODY_AFTER_DOT;
            else if (*i != '\n')
                state_ = RESPONSE_BODY;
        }
        break;
        case BODY_AFTER_DOT:
        {
            if (*i == '\n')
            {
                state_ = BEFORE_RESPONSE;
                return std::make_pair(i, true);
            }
            if (*i == '\r') state_ = BODY_AFTER_CR;
            else
                state_ = RESPONSE_BODY;
        }
        break;
        case BODY_AFTER_CR:
        {
            if (*i == '\n')
            {
                state_ = BEFORE_RESPONSE;
                return std::make_pair(i, true);
            }
            else
                state_ = RESPONSE_BODY;
        }
        break;
        }
    }
    return std::make_pair(i, false);
}

}

namespace boost { namespace asio {
template <>
struct is_match_condition<ymod_pop_client::filter> : public boost::true_type
{
};
}}

#endif //_YMOD_POP_CLIENT_FILTER_H_
