#ifndef _YMOD_PQ_H_
#define _YMOD_PQ_H_

#include <ymod_pq/bind_array.h>
#include <ymod_pq/response_handler.h>

#include <yplatform/task_context.h>
#include <yplatform/future/future.hpp>
#include <yplatform/time_traits.h>

#include <boost/lexical_cast.hpp>

namespace ymod_pq {

typedef yplatform::future::future<bool> future_result;
typedef yplatform::future::future<unsigned> future_up_result;
typedef yplatform::future::promise<bool> promise_result;
typedef yplatform::future::promise<unsigned> promise_up_result;

class call
{

public:
    call()
    {
    }

    virtual ~call()
    {
    }

    virtual future_result request(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr bind_vars,
        response_handler_ptr handler,
        bool log_timings = false,
        const yplatform::time_traits::duration& deadline =
            yplatform::time_traits::duration::max()) = 0;

    virtual future_up_result update(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr bind_arr,
        bool log_timings = false,
        const yplatform::time_traits::duration& deadline =
            yplatform::time_traits::duration::max()) = 0;

    virtual future_result execute(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr bind_arr,
        bool log_timings = false,
        const yplatform::time_traits::duration& deadline =
            yplatform::time_traits::duration::max()) = 0;
};

using call_ptr = std::shared_ptr<call>;

enum class request_target
{
    master,
    try_master,
    try_replica,
    replica
};

struct host_health
{
    bool in_fallback = false;
    double rps = 0.0;
    double error_rate = 0.0;
};

struct cluster_health
{
    host_health master;
    std::unordered_map<std::string, host_health> replicas;
};

using cluster_health_by_db = std::unordered_map<std::string, cluster_health>;

class cluster_call
{
public:
    virtual ~cluster_call() = default;

    virtual future_result request(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr bind_vars,
        response_handler_ptr handler,
        bool log_timings,
        const yplatform::time_traits::duration& deadline,
        request_target target) = 0;

    virtual future_up_result update(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr bind_arr,
        bool log_timings,
        const yplatform::time_traits::duration& deadline,
        request_target target) = 0;

    virtual future_result execute(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr bind_arr,
        bool log_timings,
        const yplatform::time_traits::duration& deadline,
        request_target target) = 0;

    virtual cluster_health_by_db get_health() = 0;
    virtual void enable_auto_fallback(const yplatform::task_context_ptr& ctx) = 0;
    virtual void disable_auto_fallback(const yplatform::task_context_ptr& ctx) = 0;
    virtual void enable_fallback(
        const yplatform::task_context_ptr& ctx,
        const std::string& db,
        request_target t) = 0;
    virtual void disable_fallback(
        const yplatform::task_context_ptr& ctx,
        const std::string& db,
        request_target t) = 0;
};

}

#endif // _YMOD_PQ_H_
