#ifndef _YMOD_PQ_ERROR_H_
#define _YMOD_PQ_ERROR_H_

#include <yplatform/exception.h>

namespace ymod_pq {

class error : public yplatform::exception
{
public:
    inline error() : yplatform::exception()
    {
    }

    explicit inline error(const std::string& cl)
        : yplatform::exception(cl, std::string(), std::string())
    {
    }

    inline error(const std::string& cl, std::string const& pub)
        : yplatform::exception(cl, pub, std::string())
    {
    }

    inline error(const std::string& cl, std::string const& pub, std::string const& prv)
        : yplatform::exception(cl, pub, prv)
    {
    }

    virtual inline ~error() throw()
    {
    }
};

struct pq_error : YPLATFORM_ERROR_DEF(pq_error, error, "ymod_pq::pq_error", "postgress error");

struct pool_error
    : YPLATFORM_ERROR_DEF(pool_error, error, "ymod_pq::pool_error", "db not found in pool");

}

#endif // _YMOD_PQ_ERROR_H_
