#ifndef _YMOD_PQ_RESPONSE_HANDLER_H_
#define _YMOD_PQ_RESPONSE_HANDLER_H_

namespace ymod_pq {

class response_handler
{
public:
    virtual ~response_handler()
    {
    }
    virtual void handle_cell(
        unsigned row,
        unsigned col,
        const std::string& value,
        bool is_null) = 0;
    virtual unsigned column_count() const = 0;
    virtual void handle_row_begin(unsigned /*row*/)
    {
    }
    virtual void handle_row_end(unsigned /*row*/)
    {
    }
};

typedef boost::shared_ptr<response_handler> response_handler_ptr;

}

#endif // _YMOD_PQ_RESPONSE_HANDLER_H_
