#ifndef _YMOD_PQ_UNESCAPE_BYTEA_H_
#define _YMOD_PQ_UNESCAPE_BYTEA_H_

#include <string>
#include <libpq-fe.h>

namespace ymod_pq {

inline std::string unescape_bytea(const std::string& value)
{
    std::size_t len = 0;
    auto bytes = PQunescapeBytea(reinterpret_cast<const unsigned char*>(value.data()), &len);
    if (!bytes)
    {
        throw std::runtime_error("PQunescapeBytea failed");
    }
    try
    {
        std::string result(reinterpret_cast<const char*>(bytes), len);
        PQfreemem(bytes);
        return result;
    }
    catch (...)
    {
        PQfreemem(bytes);
        throw;
    }
}

} // namespace ymod_pq

#endif // _YMOD_PQ_UNESCAPE_BYTEA_H_
