#ifndef _YMOD_PQ_IMPL_H_
#define _YMOD_PQ_IMPL_H_

#include <yplatform/module.h>
#include <yplatform/reactor.h>
#include <apq/connection_pool.hpp>
#include <ymod_pq/call.h>
#include <ymod_pq/error.h>
#include "settings.h"

namespace ymod_pq {

class call_impl
    : public call
    , public yplatform::module
{
public:
    call_impl(yplatform::reactor& reactor, const settings& settings);
    call_impl(yplatform::reactor& reactor, const yplatform::ptree& xml);
    virtual ~call_impl();

    yplatform::log::source& logger()
    {
        return contains_logger::logger();
    }
    yplatform::log::source& logger() const
    {
        return contains_logger::logger();
    }
    void logger(const yplatform::log::source&);

    void fini();
    void stop();

    future_result request(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr vars,
        response_handler_ptr handler,
        bool log_timings,
        const yplatform::time_traits::duration& deadline);

    future_up_result update(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr vars,
        bool log_timings,
        const yplatform::time_traits::duration& deadline);

    future_result execute(
        yplatform::task_context_ptr ctx,
        const std::string& db,
        const std::string& request,
        bind_array_ptr bind_arr,
        bool log_timings,
        const yplatform::time_traits::duration& deadline);

    yplatform::ptree get_stats() const;

private:
    void clear();

    typedef boost::shared_ptr<apq::connection_pool> pool_ptr;

    pool_ptr find_pool(const std::string& db);

    settings_ptr settings_;

    yplatform::reactor& reactor_;
    boost::shared_ptr<apq::connection_pool> pool_;
    boost::unordered_map<std::string, pool_ptr> pools_;
    mutable boost::mutex mutex_;
    std::shared_ptr<yplatform::log::contains_logger> contains_logger_;
    bool closed_;
};

}

#endif // _YMOD_PQ_IMPL_H_
