#ifndef _YMOD_PQ_QUERY_CONF_H_
#define _YMOD_PQ_QUERY_CONF_H_

#include <map>
#include <vector>
#include <boost/unordered_map.hpp>

namespace ymod_pq {

class query_conf;

class db_request
{
public:
    operator const std::string&() const
    {
        return request_;
    }

    const std::vector<int>& ind_by_name(const std::string& name) const
    {
        std::map<std::string, std::vector<int>>::const_iterator i_arg = named_args_.find(name);
        if (i_arg == named_args_.end()) return default_;
        return i_arg->second;
    }

    const std::vector<std::string>& results() const
    {
        return results_;
    }

    bool is_debug() const
    {
        return debug_;
    }

private:
    bool debug_;
    std::string request_;
    static const std::vector<int> default_;
    std::vector<std::string> results_;
    std::map<std::string, std::vector<int>> named_args_;

    friend class query_conf;
};

class query_conf
{
public:
    const db_request& request(const std::string& name) const
    {
        boost::unordered_map<std::string, db_request>::const_iterator i_req = requests_.find(name);
        if (i_req == requests_.end()) throw std::runtime_error("request_not found");
        return i_req->second;
    }

    void parse(const std::string& file_name);

private:
    boost::unordered_map<std::string, db_request> requests_;
};

}

#endif // _YMOD_PQ_QUERY_CONF_H_
