#ifndef _YMOD_PQ_QUERY_CONF_PARSER_H_
#define _YMOD_PQ_QUERY_CONF_PARSER_H_

#include <boost/config/warning_disable.hpp>
#include <boost/spirit/include/qi.hpp>
#include <boost/spirit/include/qi_eol.hpp>
#include <boost/spirit/include/phoenix_core.hpp>
#include <boost/spirit/include/phoenix_operator.hpp>
#include <boost/spirit/include/phoenix_fusion.hpp>
#include <boost/spirit/include/phoenix_stl.hpp>
#include <boost/spirit/include/phoenix_object.hpp>
#include <boost/fusion/include/adapt_struct.hpp>
#include <boost/variant/recursive_variant.hpp>

#include <map>
#include <vector>

namespace ymod_pq {

struct raw_db_request
{
    std::string name;
    std::string query;
    std::string debug;
    std::vector<std::string> structs;
    std::vector<std::string> vars;
};

struct raw_query_conf
{
    std::vector<raw_db_request> requests; // children
};

}

BOOST_FUSION_ADAPT_STRUCT(
    ymod_pq::raw_db_request,
    (std::string, name)(std::string, query)(std::string, debug)(std::vector<std::string>, structs)(
        std::vector<std::string>,
        vars))

BOOST_FUSION_ADAPT_STRUCT(ymod_pq::raw_query_conf, (std::vector<ymod_pq::raw_db_request>, requests))

namespace ymod_pq {

// namespace {

namespace fusion = boost::fusion;
namespace phoenix = boost::phoenix;
namespace qi = boost::spirit::qi;
namespace ascii = boost::spirit::qi::standard_wide;

template <typename Iterator>
struct query_conf_grammar : qi::grammar<Iterator, raw_query_conf(), ascii::space_type>
{
    query_conf_grammar() : query_conf_grammar::base_type(query_config)
    {
        using qi::lit;
        using qi::lexeme;
        using qi::raw;
        using ascii::char_;
        using ascii::string;
        using namespace qi::labels;

        using phoenix::at_c;
        using phoenix::push_back;

        query_query %= "query \"" >> raw[*(char_ - '"')] >> "\"" >> ";";
        structs %= raw[lexeme[+(char_ - ',' - ';')]] >> *("," >> raw[lexeme[+(char_ - ',' - ';')]]);
        vars %= raw[lexeme[+(char_ - ',')]] >> *("," >> raw[lexeme[+(char_ - ',' - ';')]]);
        query_name %= "sql" >> raw[lexeme[+(char_ - ';')]] >> ";";
        query_debug %= "debug" >> raw[lexeme[+(char_ - ';')]] >> ";";
        query_struct %= "struct" >> structs >> ";";
        query_vars %= "vars" >> vars >> ";";
        query_request = query_name[at_c<0>(_val) = _1] >> *query_debug[at_c<2>(_val) = _1] >>
            *query_struct[push_back(at_c<3>(_val), _1)] >>
            *query_vars[push_back(at_c<4>(_val), _1)] >> query_query[at_c<1>(_val) = _1];
        query_config = *query_request[push_back(at_c<0>(_val), _1)];
    }

    qi::rule<Iterator, raw_query_conf(), ascii::space_type> query_config;
    qi::rule<Iterator, raw_db_request(), ascii::space_type> query_request;
    qi::rule<Iterator, std::string(), ascii::space_type> query_name;
    qi::rule<Iterator, std::string(), ascii::space_type> query_debug;
    qi::rule<Iterator, std::string(), ascii::space_type> query_struct;
    qi::rule<Iterator, std::string(), ascii::space_type> query_vars;
    qi::rule<Iterator, std::string(), ascii::space_type> query_query;
    qi::rule<Iterator, std::string(), ascii::space_type> structs;
    qi::rule<Iterator, std::string(), ascii::space_type> vars;
    qi::rule<Iterator, std::string(), ascii::space_type> comment;
};

}

#endif // _YMOD_PQ_QUERY_CONF_PARSER_H_
