#pragma once

#include <yplatform/util/per_second_accumulator.h>
#include <yplatform/spinlock.h>

namespace ymod_pq {

template <typename Accumulator>
class thread_safe_accumulator_wrapper
{
    using accumulator = Accumulator;
    using accumulator_ptr = std::shared_ptr<accumulator>;
    using value_type = typename accumulator::value_type;
    using lock_guard = std::lock_guard<yplatform::spinlock>;

public:
    thread_safe_accumulator_wrapper(const accumulator_ptr& ptr) : ptr_(ptr)
    {
    }

    value_type get_sum(std::time_t now, unsigned last_count)
    {
        lock_guard l(lock_);
        return ptr_->get_sum(now, last_count);
    }

    value_type add(std::time_t now, value_type t)
    {
        lock_guard l(lock_);
        return ptr_->add(now, t);
    }

private:
    accumulator_ptr ptr_;
    yplatform::spinlock lock_;
};

}