#pragma once

#include <ymod_python/module.h>

#include <yplatform/module.h>
#include <yplatform/find.h>

#include <library/cpp/json/json_value.h>

#include <boost/python.hpp>

#include <memory>
#include <iostream>

namespace NExample {

class TExample : public yplatform::module
{
public:
    void init();
    void start();
    void stop();
    void fini();
    TExample(yplatform::reactor&, const yplatform::ptree&);
    void StringToJsonValue(const std::string&, const std::function<void(const NJson::TJsonValue&)>&);
    void JsonValueToString(std::shared_ptr<NJson::TJsonValue>&, const std::function<void(const std::string&)>&);
    void TestPyDefFromCpp();
    std::string PythonName;
    ymod_python::python_ptr Python;
    yplatform::reactor& Reactor;
};

}

