#include <mail/ymod_python/example/yplatform_mod/include/example.h>
#include <ymod_python/util.h>

namespace NExample {

void TExample::init() {
    Python = PythonName.empty() ?
             ymod_python::get_current_python() // get default python
           : yplatform::find<ymod_python::python, std::shared_ptr>(PythonName);
}

void TExample::start() {}

void TExample::stop() {}

void TExample::fini() {
    Python.reset();
}

TExample::TExample(yplatform::reactor& reactor, const yplatform::ptree& config)
    : PythonName(config.get<std::string>("python", ""))
    , Reactor(reactor)
{ }


// функция-прокси в питон
void TExample::StringToJsonValue(const std::string& s, const std::function<void(const NJson::TJsonValue&)>& fn) {
    using namespace boost::python;
    Python->async_run([s, fn] {
        // ymod_python по умолчанию грузит всё в __main__ модуль
        object main = import("__main__");
        object global(main.attr("__dict__"));
        // значит нужные нам функции ищем в __dict__ у __main__
        object string_to_json_value = global["string_to_json_value"];
        object str{s};
        try {
            // вызываем питоновскую функцию
            std::shared_ptr<NJson::TJsonValue> result = extract<std::shared_ptr<NJson::TJsonValue>>(string_to_json_value(s));
            // дёргаем плюсовый колбэк с результатом из питоновской функции
            // Предупреждение: колбэк будет вызван на питоновском реакторе под GIL
            // поэтому, чтобы не держать GIL, в fn лучше отправить ещё один колбэк в
            // реактор, подробнее см. test/src/test.cpp
            fn(*result);
        } catch (const error_already_set&) {
            PyErr_Print();
            L_(error) << "error in string_to_json_value";
        }
    });
}

// ещё одна функция-прокси
void TExample::JsonValueToString(std::shared_ptr<NJson::TJsonValue>& json_ptr, const std::function<void(const std::string&)>& fn) {
    Python->async_run([json_ptr, fn] {
        using namespace boost::python;
        object json_value_to_string = ymod_python::get_global("json_value_to_string");
        object json{json_ptr};
        try {
            object result = json_value_to_string(json);
            auto str = extract<std::string>(result);
            fn(str);
        } catch (const error_already_set&) {
            PyErr_Print();
            L_(error) << "error in json_value_to_string";
        }
    });
}

void TExample::TestPyDefFromCpp() {
    Python->async_run([] {
        using namespace boost::python;
        // более простой способ вызывать код в питоне
        ymod_python::exec(
             "def test(arg):\n"
             "    import sys\n"
             "    print('from python test function: ' + arg)\n"
             "    sys.stdout.flush()\n"
             "    return arg\n"
        );
        // более простой способ получить значение глобала
        object test_fn = ymod_python::get_global("test");
        object str{"test_arg"};
        test_fn(str);
    });
}

} // namespace NExample

#include <yplatform/module_registration.h>
REGISTER_MODULE(NExample::TExample)
