#pragma once

#include <yplatform/exception.h>

#include <boost/tuple/tuple.hpp>
#include <boost/exception/all.hpp>
#include <vector>

namespace ymod_python {

namespace py_error {

enum code : int
{
    success = 0,
    unknown_error,

    COUNT
    // DO NOT FORGET TO EXTEND error_names
};

inline const std::string& message(code err)
{
  static constexpr std::initializer_list<const char*> names = {
    "success",
    "unknown error",
  };
  static_assert(names.size() == code::COUNT, "Error codes count doesn't correspond with error names count");
  static const std::vector<std::string> error_names(names.begin(), names.end());

  return error_names[err];
}

class error_category : public boost::system::error_category
{
public:
  const char* name() const noexcept
  { return "ymod_python"; }

  std::string message(int ev) const
  { return py_error::message(code(ev)); }

  static const error_category& instance()
  {
    static const error_category category;
    return category;
  }

private:
  error_category() = default;
};

inline boost::system::error_code make_error_code(code error)
{
    return boost::system::error_code(static_cast<int>(error), error_category::instance());
}

}

using errc = py_error::code;
}

namespace boost {
namespace system {

template <>
struct is_error_code_enum<ymod_python::errc>
{
    static const bool value = true;
};

}}
