#pragma once

#include <ymod_python/errors.h>
#include <string>
#include <memory>
#include <boost/asio.hpp>

namespace ymod_python {

class python
{
public:
    using handler = std::function<void(void)>;
    using handler_with_gil_releaser = std::function<void(std::function<void(handler)>)>;

    virtual void sync_run(handler) = 0;
    virtual void async_run(handler) = 0;

    virtual void sync_run(handler_with_gil_releaser) = 0;
    virtual void async_run(handler_with_gil_releaser) = 0;

    virtual boost::asio::io_service& get_io_service() = 0;

    virtual ~python() = default;
};

using python_ptr = std::shared_ptr<python>;

python_ptr get_current_python();

}
