#pragma once
#include "sync.h"
#include <boost/python.hpp>
#include <Python.h>

namespace ymod_python {

class PyObjectShared {
public:
    PyObjectShared (PyObject* p, bool borrow=true) {
        gil_guard g;
        if (borrow) {
            Py_XINCREF(p);
        }
        ptr_ = p;
    }
    ~PyObjectShared () {
        gil_guard g;
        Py_XDECREF(ptr_);
        ptr_ = nullptr;
    }
    PyObjectShared (const PyObjectShared& o) {
        gil_guard g;
        Py_XINCREF(o.ptr_);
        ptr_ = o.ptr_;
    }
    PyObjectShared (PyObjectShared&& o) {
        ptr_ = o.ptr_;
        o.ptr_ = nullptr;
    }
    PyObjectShared& operator=(const PyObjectShared& o) {
        gil_guard g;
        Py_XINCREF(o.ptr_);
        Py_XDECREF(ptr_);
        ptr_ = o.ptr_;
        return *this;
    }
    PyObjectShared& operator=(PyObjectShared&& o) {
        ptr_ = o.ptr_;
        o.ptr_ = nullptr;
        return *this;
    }
    operator PyObject*() const {
        return ptr_;
    }
    operator boost::python::object() const {
        using namespace boost::python;
        return object{handle<>{borrowed(ptr_)}};
    }
private:
    PyObject* ptr_;
};

}
