#pragma once

#include <Python.h>

namespace ymod_python {

class gil_guard {
public:
    gil_guard() {
        initialized = Py_IsInitialized();
        if (initialized) {
            gstate = PyGILState_Ensure();
        }
    }
    ~gil_guard() {
        if (initialized) {
            PyGILState_Release(gstate);
        }
    }
private:
    bool initialized;
    PyGILState_STATE gstate;
private:
    // non-copyable, non-movable
    gil_guard(const gil_guard&) = delete;
    gil_guard(gil_guard&&) = delete;
    gil_guard& operator=(const gil_guard&) = delete;
    gil_guard& operator=(gil_guard&&) = delete;
};

}
