#pragma once
#include <boost/python.hpp>
#include <Python.h>

namespace ymod_python {

static inline boost::python::object exec(std::string code, std::string module_name = "__main__")
{
    using namespace boost::python;
    object module = import(str{module_name});
    object global(module.attr("__dict__"));
    object result = exec(str{code}, global, global);
    return result;
}

static inline boost::python::object eval(std::string code, std::string module_name = "__main__")
{
    using namespace boost::python;
    object module = import(str{module_name});
    object global(module.attr("__dict__"));
    object result = eval(str{code}, global, global);
    return result;
}

static inline boost::python::object get_global(std::string name, std::string module_name = "__main__")
{
    using namespace boost::python;
    object module = import(str{module_name});
    object global(module.attr("__dict__"));
    return global[str{name}];
}

// Use get_error_message_and_traceback() after PyErr_Print(), because PyErr_Print() sets corresponding system variables
// Without PyErr_Print() solution to get error message and traceback is too heavy and depends on python version
static inline std::tuple<std::string, std::string> get_error_message_and_traceback(std::string module_name = "__main__")
{
    exec("import traceback, sys", module_name);
    auto pyErr = eval("str(sys.last_value)", module_name);
    auto pyStackTrace = eval("'\\n'.join(traceback.format_exception(sys.last_type, sys.last_value, sys.last_traceback))", module_name);

    auto stackTraceString = boost::python::extract<std::string>(pyStackTrace);
    auto errorSummary = boost::python::extract<std::string>(pyErr);

    return {errorSummary, stackTraceString};
}

}
