#pragma once

#include <ymod_python/module.h>
#include <yplatform/module.h>
#include <yplatform/reactor.h>

#include <Python.h>

namespace ymod_python {

class impl : python, public yplatform::module
{
public:
    impl(yplatform::reactor& reactor);

    void init(const yplatform::ptree& config);
    void start();
    void reload(const yplatform::ptree& config);
    void fini();

    void sync_run(handler) override;
    void async_run(handler) override;

    void sync_run(handler_with_gil_releaser) override;
    void async_run(handler_with_gil_releaser) override;

    boost::asio::io_service& get_io_service() override;

    void register_python_in_tls();
private:
    void register_pyThreadState_in_tls();
    yplatform::reactor& reactor_;
#ifdef USE_PYTHON3
    wchar_t* program_name_;
    wchar_t* python_home_;
    wchar_t* python_path_;
#else
    std::string program_name_;
    std::string python_home_;
    std::string python_path_;
#endif
    PyThreadState* py_main_thread_;
    std::string py_source_;
};

}
