import os
from library.python import resource
from mail.devpack.lib import helpers
from mail.devpack.lib.components.base import YplatformComponent
from mail.pg.queuedb.devpack.components.queuedb import QueueDb


class QueuedbApi(YplatformComponent):
    NAME = 'queuedb_api'
    DEPS = [QueueDb]

    def __init__(self, env, components):
        super(QueuedbApi, self).__init__(env, components, binary_name='queuedb_api', custom_path='ymod_queuedb/tests')

    def init_root(self):
        self.yhttp.init_root()

        etc_queuedb_path = os.path.join(self.get_root(), 'etc', 'queuedb')
        helpers.mkdir_recursive(etc_queuedb_path)
        helpers.write2file(resource.find('ymod_queuedb/queuedb.conf'), os.path.join(etc_queuedb_path, 'queuedb.conf'))

        replace = {
            'connection_string': f'host=localhost port={self.components[QueueDb].port()} user=barbet dbname=queuedb',
        }
        config = self.yhttp.format_config(resource.find('ymod_queuedb/config.yml'), **replace)
        helpers.write2file(config, os.path.join(self.etc_path, 'queuedb_api-devpack.yml'))

    def start(self):
        self.yhttp.start('{"ping": "ok"}')
