#pragma once

#include <mail_errors/error_code.h>


namespace ymod_queuedb {

enum class QueueResult {
    ok = 0,
    internalError
};

struct QueueCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "ymod_queuedb::Cache";
    }

    std::string message(int v) const override {
        switch(QueueResult(v)) {
            case QueueResult::ok:
                return "no error";
            case QueueResult::internalError:
                return "internal error";
        }
        return "unknown error";
    }
};

const QueueCategory& getQueueCategory();
mail_errors::error_code::base_type make_error_code(QueueResult e);
mail_errors::error_code make_error(QueueResult e, const std::string& what);

}

namespace boost::system {
template <>
struct is_error_code_enum<ymod_queuedb::QueueResult>: std::true_type { };
}


