#pragma once

#include <memory>

#include <yplatform/log.h>
#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <mail/ymod_queuedb/include/queue.h>
#include <mail/webmail/commondb/include/logger.h>

namespace ymod_queuedb {

using namespace commondb;

namespace log {
using namespace ::logdog::attr;
using namespace ::commondb::attr;
constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-queuedb-tskv-log"));
}

inline auto getYplatformBackend(const std::string& name) {
    return std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, name);
}

inline auto getModuleLogger(const std::string& name) {
    auto logger = getYplatformBackend(name);
    return ::logdog::make_log(log::formatter, logger);
}
using ModuleLogger = decltype(getModuleLogger(""));

inline auto getContextLogger(const std::string& name, RequestId requestId) {
    auto logger = ::logdog::make_log(log::formatter, getYplatformBackend(name));
    return ::logdog::bind(logger, log::x_request_id=requestId);
}
using ContextLogger = decltype(getContextLogger("", RequestId()));

}
