#pragma once

#include <pgg/query/ids.h>
#include <pgg/query/boundaries.h>
#include <pgg/query/query_register.h>


PGG_QUERY_ID((ymod_queuedb)(query), Uid, std::int64_t)
PGG_QUERY_ID((ymod_queuedb)(query), TaskId, std::int64_t)
PGG_QUERY_ID((ymod_queuedb)(query), TaskType, std::string)
PGG_QUERY_ID((ymod_queuedb)(query), TaskArgs, std::optional<std::string>)
PGG_QUERY_ID((ymod_queuedb)(query), Worker, std::string)
PGG_QUERY_ID((ymod_queuedb)(query), Reason, std::string)
PGG_QUERY_ID((ymod_queuedb)(query), TasksLimit, std::int32_t)
PGG_QUERY_ID((ymod_queuedb)(query), MaxRetries, std::int32_t)
PGG_QUERY_ID((ymod_queuedb)(query), Delay, std::chrono::seconds)
PGG_QUERY_ID((ymod_queuedb)(query), Timeout, std::chrono::seconds)
PGG_QUERY_ID((ymod_queuedb)(query), RequestId, std::string)

BOOST_FUSION_DEFINE_STRUCT((ymod_queuedb)(result),
    Task,
    (std::uint64_t, task_id)
    (std::uint64_t, uid)
    (std::string, service)
    (std::string, task)
    (std::string, state)
    (boost::optional<std::string>, task_args)
    (std::uint32_t, reassignment_count)
    (std::uint32_t, tries)
    (std::vector<std::string>, try_notices)
    (std::time_t, created)
    (std::time_t, processing_date)
    (std::uint64_t, timeout_sec)
    (std::string, worker)
    (std::string, request_id)
)

BOOST_FUSION_DEFINE_STRUCT((ymod_queuedb)(result),
    AddTask,
    (std::uint64_t, task_id)
)

namespace ymod_queuedb::query {

struct AcquireTasks: pgg::query::QueryImpl<AcquireTasks, Worker, TasksLimit> {
    using Inherited::Inherited;
};

struct AddTask: pgg::query::QueryImpl<AddTask, Uid, TaskType, TaskArgs, Timeout, RequestId> {
    using Inherited::Inherited;
};

struct CompleteTask: pgg::query::QueryImpl<CompleteTask, TaskId, Worker> {
    using Inherited::Inherited;
};

struct FailTask: pgg::query::QueryImpl<FailTask, TaskId, Worker, Reason, MaxRetries, Delay> {
    using Inherited::Inherited;
};

struct DelayTask: pgg::query::QueryImpl<DelayTask, TaskId, Worker, Delay> {
    using Inherited::Inherited;
};

struct RefreshTask: pgg::query::QueryImpl<RefreshTask, TaskId, Worker> {
    using Inherited::Inherited;
};

using QueriesRegister = pgg::query::RegisterQueries<
    AcquireTasks,
    AddTask,
    CompleteTask,
    FailTask,
    DelayTask,
    RefreshTask
>;
using ParametersRegister = pgg::query::RegisterParameters<>;

}
